public class MergeSort {
    public static void main(String[] args) {
        // Example array
        int[] A = {10, 25, 30, 45, 50, 15, 5};

        // Perform merge sort
        mergeSort(A, 0, A.length - 1);

        // Output sorted array
        System.out.println("Sorted array:");
        for (int num : A) {
            System.out.print(num + " ");
        }
    }

    // MergeSort(A[l..r])
    public static void mergeSort(int[] A, int l, int r) {
        if (l < r) {
            int m = (l + r) / 2;
            mergeSort(A, l, m);
            mergeSort(A, m + 1, r);
            merge(A, l, m, r);
        }
    }

    // Merge(A[l..r], l, m, r)
    public static void merge(int[] A, int l, int m, int r) {
        // B ← new Array with r − l + 1 cells
        int[] B = new int[r - l + 1];

        // i ← l, j ← m + 1, k ← 0 
        int i = l;
        int j = m + 1;
        int k = 0;

        // while i ≤ m and j ≤ r do
        while (i <= m && j <= r) {
            if (A[i] < A[j]) {
                B[k] = A[i];
                i = i + 1;
                k = k + 1;
            } else {
                B[k] = A[j];
                j = j + 1;
                k = k + 1;
            }
        }

        // copy remaining elements
        while (i <= m) {
            B[k] = A[i];
            i = i + 1;
            k = k + 1;
        }

        while (j <= r) {
            B[k] = A[j];
            j = j + 1;
            k = k + 1;
        }

        // kopiere B nach A[l..r]
        for (int p = 0; p < B.length; p++) {
            A[l + p] = B[p];
        }
    }
}
