public class InsertionWithBinarySearch {
    public static void main(String[] args) {
        int[] A = {10, 25, 30, 45, 50, 15, 5};

        insertionSortUsingBinary(A);

        System.out.println("Sorted array:");
        for (int num : A) System.out.print(num + " ");
        System.out.println();

        // (Optional) regular binary search on the sorted array
        int b = 25;
        int pos = binarySearch(A, b);
        System.out.println("Search " + b + " → index: " + pos);
    }

    //  Insertion Sort that uses binary search for the insertion point 
    public static void insertionSortUsingBinary(int[] A) {
        int n = A.length;

        for (int j = 1; j < n; j++) {
            int x = A[j];

            // find smallest index k in {0,...,j-1} with A[k] >= x
            int k = binarySearchInsertionIndex(A, 0, j - 1, x);

            // shift A[k..j-1] right by 1 and place x at A[k]
            for (int i = j; i > k; i--) {
                A[i] = A[i - 1];
            }
            A[k] = x;
        }
    }

    // ---------- Your original binary search (returns index or -1) ----------
    public static int binarySearch(int[] A, int b) {
        int left = 0;
        int right = A.length - 1;

        while (left <= right) {
            int mid = left + (right - left) / 2;

            if (A[mid] == b) return mid;
            if (A[mid] > b)  right = mid - 1;
            else             left  = mid + 1;
        }
        return -1;
    }

    // ---------- Modified binary search: returns insertion index (lower bound) ----------
    // Smallest index in A[l..r] such that A[index] >= b; if none, returns r+1.
    private static int binarySearchInsertionIndex(int[] A, int l, int r, int b) {
        int left = l;
        int right = r + 1;                 // search interval: [left, right)

        while (left < right) {
            int mid = left + (right - left) / 2; // overflow-safe midpoint
            if (A[mid] >= b) right = mid;        // move left to find first >= b
            else             left  = mid + 1;    // move right
        }
        return left; // in [l, r+1]
    }
}
