public class InsertionSort {
    public static void main(String[] args) {
        // Example array
        int[] A = {10, 25, 30, 45, 50, 15, 5};

        // Perform insertion sort
        insertionSort(A);

        // Output sorted array
        System.out.println("Sorted array:");
        for (int num : A) {
            System.out.print(num + " ");
        }
    }

    // Insertion sort method 
    public static void insertionSort(int[] A) {
        int n = A.length;

        for (int j = 1; j < n; j++) {

            // x ← A[j]  (merke A[j])
            int x = A[j];

            // find smallest index k in {0,...,j-1} such that A[j] <= A[k]
            int k = 0;
            while (k < j && A[k] <= x) {
                k++;
            }

            // shift A[k,...,j-1] to A[k+1,...,j]
            for (int i = j; i > k; i--) {
                A[i] = A[i - 1];
            }

            // A[k] ← x
            A[k] = x;
        }
    }
}
