public class BinarySearch {
    public static void main(String[] args) {
        // Example sorted array (binary search requires sorted input!)
        int[] numbers = {5, 10, 15, 20, 25, 30, 35, 40};
        int target = 25;

        // Perform binary search
        int result = binarySearch(numbers, target);

        // Output result
        if (result == -1) {
            System.out.println("Element not found in the array.");
        } else {
            System.out.println("Element found at index: " + result);
        }
    }

    // Binary search method
    public static int binarySearch(int[] A, int b) {
        int left = 0;
        int right = A.length - 1;

        while (left <= right) {
            int mid = (left + right) / 2; 

            if (A[mid] == b) {
                return mid; // target found
            }

            if (A[mid] > b) {
                right = mid - 1; // search left half
            } else {
                left = mid + 1; // search right half
            }
        }

        return -1; // target not found
    }
}
